package it.eng.eremita.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="EREMITA_MARCATURA")
@SequenceGenerator(name="SEQ_MARCATURA", sequenceName="SEQ_MARCATURA", initialValue=1, allocationSize=1)
public class Marcatura {
	
	Long id;
	TipoMarcatura tipoMarcatura;
	String idMarcatura;
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_MARCATURA")
	@Column(name="ID")
	@GraphQLQuery(name="id",description="Id, se omesso viene creato")
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name="TIPO_MARCATURA")
	@GraphQLQuery(name="tipoMarcatura",description="La lista dei valori possibili si ottiene con {tipoMarcaturas}")
	public TipoMarcatura getTipoMarcatura() {
		return tipoMarcatura;
	}
	public void setTipoMarcatura(TipoMarcatura tipoMarcatura) {
		this.tipoMarcatura = tipoMarcatura;
	}
	
	@Column(name="ID_MARCATURA")
	@GraphQLQuery(name="idMarcatura",description="Identificatore della marcatura, inserito dall'utente")
	public String getIdMarcatura() {
		return idMarcatura;
	}
	public void setIdMarcatura(String idMarcatura) {
		this.idMarcatura = idMarcatura;
	}
	
	
	

}
